/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.solitaire;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.solitaire.SolitaireMenu;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class SolitaireGame
extends CardGame<SolitaireGame> {
    private final GameSlot stockPile;
    private final GameSlot wastePile;
    private final Map<Suit, GameSlot> foundationPiles;
    private final List<GameSlot> tableauPiles;
    @Nullable
    private Card lastStockCard = null;
    private int lastTableauDraw = -1;

    public SolitaireGame(List<CardPlayer> players, CardDeck deck) {
        super(players, deck);
        float middleX = 80.0f;
        float leftX = middleX - 12.5f - 90.0f;
        float middleY = 80.0f;
        float topY = middleY + 61.25f;
        this.stockPile = this.addSlot(new GameSlot(new LinkedList(), leftX, topY, 0.0f, 0.0f){

            @Override
            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            @Override
            public void onRemove(CardPlayer player, List<Card> cards) {
                super.onRemove(player, cards);
                SolitaireGame.this.lastStockCard = cards.getLast();
                SolitaireGame.this.lastStockCard.flip();
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        });
        this.wastePile = this.addSlot(new GameSlot(new LinkedList(), leftX + 25.0f + 5.0f, topY, 0.0f, 0.0f){

            @Override
            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return cards.size() == 1 && cards.getLast() == SolitaireGame.this.lastStockCard;
            }

            @Override
            public void onInsert(CardPlayer player, List<Card> cards) {
                super.onInsert(player, cards);
                SolitaireGame.this.lastStockCard = null;
                player.play(null);
            }

            @Override
            public void onRemove(CardPlayer player, List<Card> cards) {
                super.onRemove(player, cards);
                SolitaireGame.this.lastStockCard = cards.getLast();
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        });
        int i = 0;
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (final Suit suit : List.of(Suit.SPADES, Suit.HEARTS, Suit.CLUBS, Suit.DIAMONDS)) {
            map.put((Object)suit, (Object)this.addSlot(new GameSlot(new LinkedList(), leftX + (float)(30 * (3 + i++)), topY, 0.0f, 0.0f){

                @Override
                public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                    if (index != -1 && index != this.size()) {
                        return false;
                    }
                    int i = this.isEmpty() ? 0 : this.getLast().getRank().ordinal();
                    for (Card card : cards) {
                        if (card.getSuit() == suit && card.getRank().ordinal() == 1 + i++) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void onInsert(CardPlayer player, List<Card> cards) {
                    super.onInsert(player, cards);
                    SolitaireGame.this.lastStockCard = null;
                    if (SolitaireGame.this.lastTableauDraw >= 0) {
                        player.play(cards, SolitaireGame.this.lastTableauDraw);
                    } else {
                        player.play(null);
                    }
                    SolitaireGame.this.lastTableauDraw = -1;
                }

                @Override
                public boolean canRemoveCard(CardPlayer player, int index) {
                    return false;
                }
            }));
        }
        this.foundationPiles = map.build();
        ImmutableList.Builder list = ImmutableList.builder();
        for (i = 0; i < 7; ++i) {
            final int s = 6 + i;
            list.add((Object)this.addSlot(new GameSlot(new LinkedList(), leftX + 25.0f + (float)(30 * i), topY + 5.0f + 35.0f - 52.5f, 0.0f, 180.0f, class_2350.field_11043, 105.0f, false){

                @Override
                public boolean canRemoveCard(CardPlayer player, int index) {
                    if (index == -1) {
                        return this.size() == 1;
                    }
                    Card last = null;
                    for (int i = index; i < this.size(); ++i) {
                        Card current = this.get(i);
                        if (last != null && (last.isFlipped() || !SolitaireGame.isAlternate(last, current))) {
                            return false;
                        }
                        last = current;
                    }
                    return true;
                }

                @Override
                public void onRemove(CardPlayer player, List<Card> cards) {
                    super.onRemove(player, cards);
                    SolitaireGame.this.lastTableauDraw = s;
                }

                @Override
                public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                    if (SolitaireGame.this.lastTableauDraw == s) {
                        return true;
                    }
                    Card last = this.isEmpty() ? null : this.getLast();
                    for (Card current : cards) {
                        if (last == null && current.getRank() != Rank.KING || last != null && !SolitaireGame.isAlternate(last, current) || last != null && current.getRank().ordinal() + 1 != last.getRank().ordinal()) {
                            return false;
                        }
                        last = current;
                    }
                    return true;
                }

                @Override
                public void onInsert(CardPlayer player, List<Card> cards) {
                    super.onInsert(player, cards);
                    SolitaireGame.this.lastStockCard = null;
                    if (SolitaireGame.this.lastTableauDraw != s && SolitaireGame.this.lastTableauDraw >= 0) {
                        player.play(cards, SolitaireGame.this.lastTableauDraw);
                    } else {
                        player.play(null);
                    }
                    SolitaireGame.this.lastTableauDraw = -1;
                }
            }));
        }
        this.tableauPiles = list.build();
    }

    @Override
    public AbstractCardMenu<SolitaireGame> createMenu(int containerId, class_1661 playerInventory, class_3218 level, class_2338 pos, CardDeck deck) {
        return new SolitaireMenu(containerId, playerInventory, class_3914.method_17392((class_1937)level, (class_2338)pos), deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    @Override
    public Predicate<CardDeck> getDeckPredicate() {
        return deck -> {
            for (Suit suit : Suit.values()) {
                for (Rank rank : Rank.values()) {
                    if (suit == Suit.BLANK || rank == Rank.BLANK || rank == Rank.JOKER || deck.getCards().contains((Object)new Card(suit, rank))) continue;
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public Predicate<Card> getCardPredicate() {
        return card -> card.getSuit() != Suit.BLANK && card.getRank() != Rank.BLANK && card.getRank() != Rank.JOKER;
    }

    @Override
    public boolean canPlay(CardPlayer player, CardPlay play) {
        return false;
    }

    @Override
    public void startGame() {
        this.stockPile.clear();
        this.wastePile.clear();
        this.foundationPiles.values().forEach(GameSlot::clear);
        this.tableauPiles.forEach(GameSlot::clear);
        this.stockPile.addAll(this.gameDeck);
        this.stockPile.shuffle();
        for (CardPlayer player : this.players) {
            player.resetPlay();
            this.getPlayerHand(player).clear();
            this.getCensoredHand(player).clear();
        }
        for (int i = 0; i < this.tableauPiles.size(); ++i) {
            for (int j = 0; j < this.tableauPiles.size(); ++j) {
                int slot = j;
                int amount = i;
                if (slot < amount) continue;
                this.scheduledActions.add(() -> {
                    this.currentPlayer.playSound(ModSounds.CARD_DRAW);
                    Card card = this.stockPile.removeLast();
                    if (slot == amount) {
                        card.flip();
                    }
                    this.tableauPiles.get(slot).addLast(card);
                });
                this.scheduledActions.add(() -> {});
            }
        }
        this.currentPlayer = (CardPlayer)this.players.getFirst();
        this.isGameReady = false;
        this.isGameOver = false;
        this.table((class_2561)class_2561.method_43471((String)"message.charta.game_started"));
    }

    @Override
    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play != null) {
                GameSlot s = this.getSlot(play.slot());
                if (!s.isEmpty() && s.getLast().isFlipped()) {
                    s.getLast().flip();
                    s.setDirty(true);
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43469((String)"message.charta.revealed_a_card", (Object[])new Object[]{class_2561.method_43471((String)this.deck.getCardTranslatableKey(s.getLast())), play.slot() - 5}));
                } else {
                    this.play(this.currentPlayer, (class_2561)class_2561.method_43471((String)"message.charta.did_a_move"));
                }
            } else {
                this.play(this.currentPlayer, (class_2561)class_2561.method_43471((String)"message.charta.did_a_move"));
            }
            if (this.stockPile.isEmpty()) {
                this.wastePile.forEach(Card::flip);
                this.wastePile.reverse();
                this.stockPile.addAll(this.wastePile);
                this.wastePile.clear();
            }
            boolean allEmpty = true;
            for (GameSlot slot : this.tableauPiles) {
                allEmpty = allEmpty && slot.isEmpty();
            }
            if (allEmpty) {
                this.endGame();
            } else {
                this.runGame();
            }
        });
    }

    @Override
    public void endGame() {
        boolean allEmpty = true;
        for (GameSlot slot : this.tableauPiles) {
            allEmpty = allEmpty && slot.isEmpty();
        }
        if (allEmpty) {
            this.currentPlayer.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.you_won").method_27692(class_124.field_1060), (class_2561)class_2561.method_43471((String)"message.charta.congratulations"));
        } else {
            this.currentPlayer.sendTitle((class_2561)class_2561.method_43471((String)"message.charta.you_lost").method_27692(class_124.field_1061), (class_2561)class_2561.method_43471((String)"message.charta.give_up"));
        }
        this.isGameOver = true;
    }

    @Override
    public int getMinPlayers() {
        return 1;
    }

    @Override
    public int getMaxPlayers() {
        return 1;
    }

    @Override
    public List<GameOption<?>> getOptions() {
        return List.of();
    }

    public static boolean isAlternate(Card c1, Card c2) {
        boolean v1 = c1.getSuit() == Suit.HEARTS || c1.getSuit() == Suit.DIAMONDS;
        boolean v2 = c2.getSuit() == Suit.HEARTS || c2.getSuit() == Suit.DIAMONDS;
        return v1 != v2;
    }
}

